/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.travelerstitles.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.yungnickyoung.minecraft.travelerstitles.config.TTConfig;
import com.yungnickyoung.minecraft.travelerstitles.init.TTModClient;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.ResourceLocationArgument;
import net.minecraft.command.arguments.SuggestionProviders;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.biome.Biome;

public class BiomeTitleCommand {
    public static final DynamicCommandExceptionType BIOME_NOT_FOUND_EXCEPTION = new DynamicCommandExceptionType(formatArgs -> new TranslationTextComponent("commands.locatebiome.invalid", new Object[]{formatArgs}));

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"biometitle").requires(source -> source.func_197034_c(2))).then(Commands.func_197056_a((String)"biome", (ArgumentType)ResourceLocationArgument.func_197197_a()).suggests(SuggestionProviders.field_239574_d_).executes(context -> BiomeTitleCommand.displayTitle((CommandSource)context.getSource(), (ResourceLocation)context.getArgument("biome", ResourceLocation.class)))));
    }

    public static int displayTitle(CommandSource commandSource, ResourceLocation biomeId) throws CommandSyntaxException {
        Biome biome = (Biome)commandSource.func_197028_i().func_244267_aX().func_243612_b(Registry.field_239720_u_).func_241873_b(biomeId).orElseThrow(() -> BIOME_NOT_FOUND_EXCEPTION.create((Object)biomeId));
        ResourceLocation biomeBaseKey = commandSource.func_197028_i().func_244267_aX().func_243612_b(Registry.field_239720_u_).func_177774_c((Object)biome);
        String overrideBiomeNameKey = Util.func_200697_a((String)"travelerstitles.biome", (ResourceLocation)biomeBaseKey);
        String normalBiomeNameKey = Util.func_200697_a((String)"biome", (ResourceLocation)biomeBaseKey);
        if (TTModClient.blacklistedBiomes.contains(biomeBaseKey.toString())) {
            commandSource.func_197030_a((ITextComponent)new StringTextComponent("That biome is blacklisted, so its title won't normally show!"), false);
        }
        if (biomeBaseKey != null) {
            TranslationTextComponent biomeTitle;
            if (LanguageMap.func_74808_a().func_230506_b_(overrideBiomeNameKey)) {
                biomeTitle = new TranslationTextComponent(overrideBiomeNameKey);
            } else if (LanguageMap.func_74808_a().func_230506_b_(normalBiomeNameKey)) {
                biomeTitle = new TranslationTextComponent(normalBiomeNameKey);
            } else {
                return 0;
            }
            String overrideBiomeColorKey = overrideBiomeNameKey + ".color";
            String normalBiomeColorKey = normalBiomeNameKey + ".color";
            String biomeColorStr = LanguageMap.func_74808_a().func_230506_b_(overrideBiomeColorKey) ? LanguageMap.func_74808_a().func_230503_a_(overrideBiomeColorKey) : (LanguageMap.func_74808_a().func_230506_b_(normalBiomeColorKey) ? LanguageMap.func_74808_a().func_230503_a_(normalBiomeColorKey) : TTModClient.biomeTitleRenderer.titleDefaultTextColor);
            TTModClient.biomeTitleRenderer.setColor(biomeColorStr);
            TTModClient.biomeTitleRenderer.displayTitle((ITextComponent)biomeTitle, null);
            TTModClient.biomeTitleRenderer.cooldownTimer = (Integer)TTConfig.biomes.textCooldownTime.get();
            return 1;
        }
        return 0;
    }
}

